package edu.uky.ai.ml;

import edu.uky.ai.ml.nn.Database;

/**
 * A training database of 5x7 pixel images of capital letters.
 * 
 * @author Stephen G. Ware
 */
public class AlphabetDatabase extends Database {
	
	/**
	 * Constructs a new alphabet training database.
	 */
	public AlphabetDatabase() {
		addExample(new double[]{
				0,0,1,0,0,
				0,1,0,1,0,
				1,0,0,0,1,
				1,1,1,1,1,
				1,0,0,0,1,
				1,0,0,0,1,
				1,0,0,0,1,
		}, new double[]{
				1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
		},
				"A"
		);
		addExample(new double[]{
				1,1,1,1,0,
				1,1,0,0,1,
				1,0,0,0,1,
				1,1,1,1,0,
				1,0,0,0,1,
				1,0,0,0,1,
				1,1,1,1,0,
		}, new double[]{
				0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
		},
				"B"
		);
		addExample(new double[]{
				1,1,1,1,1,
				1,0,0,0,0,
				1,0,0,0,0,
				1,0,0,0,0,
				1,0,0,0,0,
				1,0,0,0,0,
				1,1,1,1,1,
		}, new double[]{
				0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
		},
				"C"
		);
		addExample(new double[]{
				1,1,1,1,0,
				1,0,0,0,1,
				1,0,0,0,1,
				1,0,0,0,1,
				1,0,0,0,1,
				1,0,0,0,1,
				1,1,1,1,0,
		}, new double[]{
				0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
		},
				"D"
		);
		addExample(new double[]{
				1,1,1,1,1,
				1,0,0,0,0,
				1,0,0,0,0,
				1,1,1,1,0,
				1,0,0,0,0,
				1,0,0,0,0,
				1,1,1,1,1,
		}, new double[]{
				0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
		},
				"E"
		);
		addExample(new double[]{
				1,1,1,1,1,
				1,0,0,0,0,
				1,0,0,0,0,
				1,1,1,1,0,
				1,0,0,0,0,
				1,0,0,0,0,
				1,0,0,0,0,
		}, new double[]{
				0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
		},
				"F"
		);
		addExample(new double[]{
				0,1,1,1,0,
				1,0,0,0,1,
				1,0,0,0,0,
				1,0,1,1,1,
				1,0,0,0,1,
				1,0,0,0,1,
				0,1,1,1,0,
		}, new double[]{
				0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
		},
				"G"
		);
		addExample(new double[]{
				1,0,0,0,1,
				1,0,0,0,1,
				1,0,0,0,1,
				1,1,1,1,1,
				1,0,0,0,1,
				1,0,0,0,1,
				1,0,0,0,1,
		}, new double[]{
				0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
		},
				"H"
		);
		addExample(new double[]{
				1,1,1,1,1,
				0,0,1,0,0,
				0,0,1,0,0,
				0,0,1,0,0,
				0,0,1,0,0,
				0,0,1,0,0,
				1,1,1,1,1,
		}, new double[]{
				0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
		},
				"I"
		);
		addExample(new double[]{
				0,0,0,0,1,
				0,0,0,0,1,
				0,0,0,0,1,
				1,0,0,0,1,
				1,0,0,0,1,
				1,0,0,0,1,
				0,1,1,1,0,
		}, new double[]{
				0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
		},
				"J"
		);
		addExample(new double[]{
				1,0,0,0,1,
				1,0,0,1,0,
				1,0,1,0,0,
				1,1,0,0,0,
				1,0,1,0,0,
				1,0,0,1,0,
				1,0,0,0,1,
		}, new double[]{
				0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
		},
				"K"
		);
		addExample(new double[]{
				1,0,0,0,0,
				1,0,0,0,0,
				1,0,0,0,0,
				1,0,0,0,0,
				1,0,0,0,0,
				1,0,0,0,0,
				1,1,1,1,1,
		}, new double[]{
				0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
		},
				"L"
		);
		addExample(new double[]{
				1,0,0,0,1,
				1,1,0,1,1,
				1,0,1,0,1,
				1,0,0,0,1,
				1,0,0,0,1,
				1,0,0,0,1,
				1,0,0,0,1,
		}, new double[]{
				0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,
		},
				"M"
		);
		addExample(new double[]{
				1,0,0,0,1,
				1,0,0,0,1,
				1,1,0,0,1,
				1,0,1,0,1,
				1,0,0,1,1,
				1,0,0,0,1,
				1,0,0,0,1,
		}, new double[]{
				0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,
		},
				"N"
		);
		addExample(new double[]{
				0,1,1,1,0,
				1,0,0,0,1,
				1,0,0,0,1,
				1,0,0,0,1,
				1,0,0,0,1,
				1,0,0,0,1,
				0,1,1,1,0,
		}, new double[]{
				0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,
		},
				"O"
		);
		addExample(new double[]{
				1,1,1,1,0,
				1,0,0,0,1,
				1,0,0,0,1,
				1,1,1,1,0,
				1,0,0,0,0,
				1,0,0,0,0,
				1,0,0,0,0,
		}, new double[]{
				0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,
		},
				"P"
		);
		addExample(new double[]{
				0,1,1,1,0,
				1,0,0,0,1,
				1,0,0,0,1,
				1,0,0,0,1,
				1,0,1,0,1,
				1,0,0,1,0,
				0,1,1,0,1,
		}, new double[]{
				0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,
		},
				"Q"
		);
		addExample(new double[]{
				1,1,1,1,0,
				1,0,0,0,1,
				1,0,0,0,1,
				1,1,1,1,0,
				1,0,1,0,0,
				1,0,0,1,0,
				1,0,0,0,1,
		}, new double[]{
				0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,
		},
				"R"
		);
		addExample(new double[]{
				0,1,1,1,1,
				1,0,0,0,0,
				1,0,0,0,0,
				0,1,1,1,0,
				0,0,0,0,1,
				0,0,0,0,1,
				1,1,1,1,0,
		}, new double[]{
				0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,
		},
				"S"
		);
		addExample(new double[]{
				1,1,1,1,1,
				0,0,1,0,0,
				0,0,1,0,0,
				0,0,1,0,0,
				0,0,1,0,0,
				0,0,1,0,0,
				0,0,1,0,0,
		}, new double[]{
				0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,
		},
				"T"
		);
		addExample(new double[]{
				1,0,0,0,1,
				1,0,0,0,1,
				1,0,0,0,1,
				1,0,0,0,1,
				1,0,0,0,1,
				1,0,0,0,1,
				0,1,1,1,0,
		}, new double[]{
				0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,
		},
				"U"
		);
		addExample(new double[]{
				1,0,0,0,1,
				1,0,0,0,1,
				1,0,0,0,1,
				1,0,0,0,1,
				1,0,0,0,1,
				0,1,0,1,0,
				0,0,1,0,0,
		}, new double[]{
				0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,
		},
				"V"
		);
		addExample(new double[]{
				1,0,0,0,1,
				1,0,0,0,1,
				1,0,0,0,1,
				1,0,0,0,1,
				1,0,1,0,1,
				1,1,0,1,1,
				1,0,0,0,1,
		}, new double[]{
				0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,
		},
				"W"
		);
		addExample(new double[]{
				1,0,0,0,1,
				1,0,0,0,1,
				0,1,0,1,0,
				0,0,1,0,0,
				0,1,0,1,0,
				1,0,0,0,1,
				1,0,0,0,1,
		}, new double[]{
				0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,
		},
				"X"
		);
		addExample(new double[]{
				1,0,0,0,1,
				1,0,0,0,1,
				0,1,0,1,0,
				0,0,1,0,0,
				0,0,1,0,0,
				0,0,1,0,0,
				0,0,1,0,0,
		}, new double[]{
				0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,
		},
				"Y"
		);
		addExample(new double[]{
				1,1,1,1,1,
				0,0,0,0,1,
				0,0,0,1,0,
				0,0,1,0,0,
				0,1,0,0,0,
				1,0,0,0,0,
				1,1,1,1,1,
		}, new double[]{
				0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,
		},
				"Z"
		);
	}
}
